<?php include 'header.php'; ?>

<div class="row mb-4">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <h1 class="h3 mb-0"><i class="fas fa-tachometer-alt me-2"></i> Dashboard</h1>
            <div class="dropdown">
                <button class="btn btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="fas fa-calendar me-1"></i> Last 30 Days
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item period-filter" data-period="today">Today</a></li>
                    <li><a class="dropdown-item period-filter" data-period="yesterday">Yesterday</a></li>
                    <li><a class="dropdown-item period-filter" data-period="last_week">Last 7 Days</a></li>
                    <li><a class="dropdown-item period-filter active" data-period="last_30">Last 30 Days</a></li>
                    <li><a class="dropdown-item period-filter" data-period="last_month">Last Month</a></li>
                    <li><a class="dropdown-item period-filter" data-period="last_year">Last Year</a></li>
                    <li><a class="dropdown-item period-filter" data-period="all_time">All Time</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" data-bs-toggle="collapse" href="#customDateRange">Custom Range</a></li>
                </ul>
            </div>
        </div>
        
        <div class="collapse mt-3" id="customDateRange">
            <div class="card card-body">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">From Date</label>
                        <input type="date" class="form-control" id="fromDate">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">To Date</label>
                        <input type="date" class="form-control" id="toDate">
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button class="btn btn-primary" id="applyCustomRange">Apply</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mb-4" id="summaryCards">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Sales</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800" id="totalSales">৳ 0.00</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Profit</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800" id="totalProfit">৳ 0.00</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Ad Costs</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800" id="totalAdCost">৳ 0.00</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Net Profit</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800" id="netProfit">৳ 0.00</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-coins fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts -->
<div class="row mb-4">
    <div class="col-lg-8">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-primary">Sales Overview</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="salesChart"></canvas>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Profit Distribution</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="profitChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Additional Charts -->
<div class="row">
    <div class="col-lg-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Cost Analysis</h6>
            </div>
            <div class="card-body">
                <div class="chart-bar">
                    <canvas id="costChart"></canvas>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Average Cost Per Sale</h6>
            </div>
            <div class="card-body">
                <div class="text-center">
                    <div class="h2 text-primary mb-0" id="avgCostPerSale">৳ 0.00</div>
                    <p class="text-muted">Average advertising cost per sale</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    let currentPeriod = 'last_30';
    let fromDate = '';
    let toDate = '';
    
    // Load dashboard data
    function loadDashboardData() {
        $.ajax({
            url: 'ajax_dashboard.php',
            type: 'POST',
            data: {
                period: currentPeriod,
                from_date: fromDate,
                to_date: toDate
            },
            success: function(response) {
                const data = JSON.parse(response);
                
                // Update summary cards
                $('#totalSales').text('৳ ' + data.total_sales.toLocaleString());
                $('#totalProfit').text('৳ ' + data.total_profit.toLocaleString());
                $('#totalAdCost').text('৳ ' + data.total_ad_cost.toLocaleString());
                $('#netProfit').text('৳ ' + data.net_profit.toLocaleString());
                $('#avgCostPerSale').text('৳ ' + data.avg_cost_per_sale.toLocaleString());
                
                // Update charts
                updateCharts(data.chart_data);
            }
        });
    }
    
    // Period filter click
    $('.period-filter').click(function() {
        $('.period-filter').removeClass('active');
        $(this).addClass('active');
        currentPeriod = $(this).data('period');
        fromDate = '';
        toDate = '';
        $('#customDateRange').collapse('hide');
        loadDashboardData();
    });
    
    // Apply custom date range
    $('#applyCustomRange').click(function() {
        fromDate = $('#fromDate').val();
        toDate = $('#toDate').val();
        if (fromDate && toDate) {
            currentPeriod = 'custom';
            loadDashboardData();
        }
    });
    
    // Initial load
    loadDashboardData();
    
    function updateCharts(chartData) {
        // Sales Chart
        const salesCtx = document.getElementById('salesChart').getContext('2d');
        new Chart(salesCtx, {
            type: 'line',
            data: {
                labels: chartData.dates,
                datasets: [{
                    label: 'Sales',
                    data: chartData.sales,
                    borderColor: '#4e73df',
                    backgroundColor: 'rgba(78, 115, 223, 0.05)',
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
        
        // Profit Chart
        const profitCtx = document.getElementById('profitChart').getContext('2d');
        new Chart(profitCtx, {
            type: 'doughnut',
            data: {
                labels: ['Gross Profit', 'Ad Costs', 'Net Profit'],
                datasets: [{
                    data: [chartData.gross_profit, chartData.ad_costs, chartData.net_profit],
                    backgroundColor: ['#4e73df', '#e74a3b', '#1cc88a'],
                    hoverBackgroundColor: ['#2e59d9', '#e02d1b', '#17a673']
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                cutout: '70%'
            }
        });
        
        // Cost Chart
        const costCtx = document.getElementById('costChart').getContext('2d');
        new Chart(costCtx, {
            type: 'bar',
            data: {
                labels: chartData.dates,
                datasets: [{
                    label: 'Ad Costs',
                    data: chartData.ad_costs_data,
                    backgroundColor: '#e74a3b'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
    }
});
</script>

<?php include 'footer.php'; ?>