<?php include 'header.php'; ?>

<div class="row mb-4">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <h1 class="h3 mb-0"><i class="fas fa-shopping-cart me-2"></i> Sales Management</h1>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSaleModal">
                <i class="fas fa-plus me-1"></i> Add Sale
            </button>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card shadow mb-4">
    <div class="card-body">
        <form id="salesFilterForm">
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label">Date From</label>
                    <input type="date" class="form-control" name="date_from" id="dateFrom">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Date To</label>
                    <input type="date" class="form-control" name="date_to" id="dateTo">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Product</label>
                    <select class="form-select" name="product_id" id="productFilter">
                        <option value="">All Products</option>
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="button" class="btn btn-outline-primary me-2" id="applyFilters">Apply</button>
                    <button type="button" class="btn btn-outline-secondary" id="resetFilters">Reset</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Sales Table -->
<div class="card shadow">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Sales Records</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover" id="salesTable" width="100%" cellspacing="0">
                <thead class="table-light">
                    <tr>
                        <th>Date</th>
                        <th>Product</th>
                        <th>Quantity</th>
                        <th>Unit Price</th>
                        <th>Total Sale</th>
                        <th>Cost</th>
                        <th>Profit</th>
                        <th>Profit %</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Data will be loaded via AJAX -->
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add Sale Modal -->
<div class="modal fade" id="addSaleModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Sale</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="addSaleForm">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Product</label>
                                <select class="form-select" name="product_id" id="saleProduct" required>
                                    <option value="">Select Product</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Sale Date</label>
                                <input type="date" class="form-control" name="sale_date" value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Quantity</label>
                                <input type="number" class="form-control" name="quantity" min="1" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Selling Price</label>
                                <input type="number" class="form-control" name="selling_price" step="0.01" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Cost Price</label>
                                <input type="number" class="form-control" name="cost_price" step="0.01" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Remarks (Optional)</label>
                        <textarea class="form-control" name="remarks" rows="2"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="saveSale">Save Sale</button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Load products for dropdowns
    function loadProducts() {
        $.ajax({
            url: 'ajax_products.php',
            type: 'GET',
            data: { action: 'get_active_products' },
            success: function(response) {
                const products = JSON.parse(response);
                let options = '<option value="">All Products</option>';
                let saleOptions = '<option value="">Select Product</option>';
                
                products.forEach(product => {
                    options += `<option value="${product.id}">${product.name}</option>`;
                    saleOptions += `<option value="${product.id}" data-cost="${product.cost_price}" data-price="${product.selling_price}">${product.name}</option>`;
                });
                
                $('#productFilter').html(options);
                $('#saleProduct').html(saleOptions);
            }
        });
    }
    
    // Load sales data
    function loadSales() {
        const formData = $('#salesFilterForm').serialize();
        
        $.ajax({
            url: 'ajax_sales.php',
            type: 'GET',
            data: formData + '&action=get_sales',
            success: function(response) {
                $('#salesTable tbody').html(response);
            }
        });
    }
    
    // Product change in sale form
    $('#saleProduct').change(function() {
        const selectedOption = $(this).find('option:selected');
        const costPrice = selectedOption.data('cost');
        const sellingPrice = selectedOption.data('price');
        
        $('input[name="cost_price"]').val(costPrice);
        $('input[name="selling_price"]').val(sellingPrice);
    });
    
    // Save sale
    $('#saveSale').click(function() {
        const formData = $('#addSaleForm').serialize();
        
        $.ajax({
            url: 'ajax_sales.php',
            type: 'POST',
            data: formData + '&action=add_sale',
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    $('#addSaleModal').modal('hide');
                    $('#addSaleForm')[0].reset();
                    loadSales();
                    showAlert('Sale added successfully!', 'success');
                } else {
                    showAlert(result.message, 'error');
                }
            }
        });
    });
    
    // Apply filters
    $('#applyFilters').click(function() {
        loadSales();
    });
    
    // Reset filters
    $('#resetFilters').click(function() {
        $('#salesFilterForm')[0].reset();
        loadSales();
    });
    
    // Initialize
    loadProducts();
    loadSales();
    
    // Set default dates
    const today = new Date().toISOString().split('T')[0];
    const lastMonth = new Date();
    lastMonth.setMonth(lastMonth.getMonth() - 1);
    const lastMonthStr = lastMonth.toISOString().split('T')[0];
    
    $('#dateFrom').val(lastMonthStr);
    $('#dateTo').val(today);
});
</script>

<?php include 'footer.php'; ?>